/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.modules.IAssignsJob;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.jetbrains.annotations.NotNull;

public class CourierAssignmentModule
extends AbstractAssignedCitizenModule
implements IAssignsJob,
IBuildingEventsModule,
ITickingModule,
IPersistentModule {
    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (!this.isFull() && (this.getHiringMode() == HiringMode.DEFAULT && !this.building.getColony().isManualHiring() || this.getHiringMode() == HiringMode.AUTO)) {
            for (ICitizenData data : colony.getCitizenManager().getCitizens()) {
                if (!(data.getJob() instanceof JobDeliveryman) || this.hasAssignedCitizen(data) || ((JobDeliveryman)data.getJob()).findWareHouse() != null) continue;
                this.assignCitizen(data);
            }
        }
        for (ICitizenData citizenData : new ArrayList<ICitizenData>(this.getAssignedCitizen())) {
            if (citizenData.getJob() instanceof JobDeliveryman) continue;
            this.removeCitizen(citizenData);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        int[] residentIds;
        super.deserializeNBT(compound);
        CompoundNBT jobCompound = compound.func_74775_l(this.getModuleSerializationIdentifier());
        for (int citizenId : residentIds = jobCompound.func_74759_k("couriers")) {
            ICitizenData citizen = this.building.getColony().getCitizenManager().getCivilian(citizenId);
            if (citizen == null) continue;
            this.assignCitizen(citizen);
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        CompoundNBT jobCompound;
        super.serializeNBT(compound);
        CompoundNBT compoundNBT = jobCompound = compound.func_74764_b(this.getModuleSerializationIdentifier()) ? compound.func_74775_l(this.getModuleSerializationIdentifier()) : new CompoundNBT();
        if (!this.assignedCitizen.isEmpty()) {
            int[] residentIds = new int[this.assignedCitizen.size()];
            for (int i = 0; i < this.assignedCitizen.size(); ++i) {
                residentIds[i] = ((ICitizenData)this.assignedCitizen.get(i)).getId();
            }
            jobCompound.func_74783_a("couriers", residentIds);
        }
        compound.func_218657_a(this.getModuleSerializationIdentifier(), (INBT)jobCompound);
    }

    @Override
    public void onRemoval(ICitizenData citizen) {
    }

    @Override
    public void onAssignment(ICitizenData citizen) {
    }

    @Override
    public int getModuleMax() {
        return this.building.getBuildingLevel() * 2;
    }

    @Override
    public JobEntry getJobEntry() {
        return ModJobs.delivery;
    }

    @Override
    protected String getModuleSerializationIdentifier() {
        return "warehouse";
    }
}

